/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.util.Lazy;

public class AdvancedDistanceJigsawStructure
extends AdvancedJigsawStructure {
    protected final int distanceFromWorldOrigin;

    public AdvancedDistanceJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int biomeRange, Lazy<Integer> maxY, Lazy<Integer> minY, boolean clipOutOfBoundsPieces, Lazy<Integer> verticalRange, int distanceFromWorldOrigin) {
        super(poolID, structureSize, biomeRange, maxY, minY, clipOutOfBoundsPieces, verticalRange);
        this.distanceFromWorldOrigin = distanceFromWorldOrigin;
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        int xBlockPos = chunkX * 16;
        int zBlockPos = chunkZ * 16;
        int radius = this.distanceFromWorldOrigin;
        return xBlockPos * xBlockPos + zBlockPos * zBlockPos > radius * radius;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static class Builder<T extends Builder<T>>
    extends AdvancedJigsawStructure.Builder<T> {
        protected int distanceFromWorldOrigin = 2817;

        public Builder(ResourceLocation startPool) {
            super(startPool);
        }

        public T setDistanceFromWorldOrigin(int distanceFromWorldOrigin) {
            this.distanceFromWorldOrigin = distanceFromWorldOrigin;
            return (T)((Builder)this.getThis());
        }

        @Override
        public AdvancedDistanceJigsawStructure build() {
            return new AdvancedDistanceJigsawStructure(this.startPool, (Lazy<Integer>)this.structureSize, this.biomeRange, (Lazy<Integer>)this.maxY, (Lazy<Integer>)this.minY, this.clipOutOfBoundsPieces, (Lazy<Integer>)this.verticalRange, this.distanceFromWorldOrigin);
        }
    }

    public class Start
    extends AdvancedJigsawStructure.MainStart {
        private final ResourceLocation structureID;

        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(AdvancedDistanceJigsawStructure.this, structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
            this.structureID = Registry.field_218361_B.func_177774_c(structureIn);
        }

        @Override
        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            int bottomClipOff;
            int topClipOff;
            BlockPos.Mutable blockpos = new BlockPos.Mutable(chunkX * 16, 0, chunkZ * 16);
            if ((Integer)AdvancedDistanceJigsawStructure.this.maxY.get() - (Integer)AdvancedDistanceJigsawStructure.this.minY.get() <= 0) {
                RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + Registry.field_218361_B.func_177774_c((Object)this.func_214627_k()));
            }
            int structureStartHeight = this.field_214631_d.nextInt((Integer)AdvancedDistanceJigsawStructure.this.maxY.get() - (Integer)AdvancedDistanceJigsawStructure.this.minY.get()) + (Integer)AdvancedDistanceJigsawStructure.this.minY.get();
            blockpos.func_189534_c(Direction.UP, structureStartHeight);
            if (AdvancedDistanceJigsawStructure.this.verticalRange == null) {
                topClipOff = AdvancedDistanceJigsawStructure.this.clipOutOfBoundsPieces ? (Integer)AdvancedDistanceJigsawStructure.this.maxY.get() + 5 : Integer.MAX_VALUE;
                bottomClipOff = AdvancedDistanceJigsawStructure.this.clipOutOfBoundsPieces ? (Integer)AdvancedDistanceJigsawStructure.this.minY.get() - 5 : Integer.MIN_VALUE;
            } else {
                topClipOff = structureStartHeight + (Integer)AdvancedDistanceJigsawStructure.this.verticalRange.get();
                bottomClipOff = structureStartHeight - (Integer)AdvancedDistanceJigsawStructure.this.verticalRange.get();
            }
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(AdvancedDistanceJigsawStructure.this.startPool), ((Integer)AdvancedDistanceJigsawStructure.this.structureSize.get()).intValue()), chunkGenerator, structureManager, (BlockPos)blockpos, this.field_75075_a, (Random)this.field_214631_d, false, false, this.structureID, topClipOff, bottomClipOff);
            this.func_202500_a();
        }
    }
}

